﻿{
  Výstupní řádek dat musí být ve formátu:
   
    [,],1/0,atributy,mac,ssid,radioname,freq,level,noise,snr,
         
    - 1/0 určuje jestli je zařízení online (1) nebo offline (0)
    - FREQ musí být čislo. Pokud není známá, použij hodnotu "-1"
    - LEVEL musí být čislo. Pokud není známá, použij hodnotu "-1"
    - NOISE musí být čislo. Pokud není známá, použij hodnotu "-1"   
    - SNR musí být čislo. Pokud není známá, použij hodnotu "-1"
    
    - [x] určuje oddělovač dat a musí být na začátku řádku
    - počet řádků ve výstupu není omezen
  
  Proměnné ve skriptu:    
    - InputSl => TStringList obsahující vstupní data
    - ResultSL => TStringList obsahující výstupní data
    
}
{
//hlavicky muzou vypadat takto
 #       FREQ ADDRESS           SIG SNR OF-FREQ OF-TRAF        BW SSID   -> u noveho firmwaru
 #    FREQ    ADDRESS           SIG SNR OF-FREQ OF-TRAF BW        SSID   -> driv
 #       FREQ ADDRESS           SIG SNR OF-FREQ OF-TRAF        BW SSID    -> ted
 0 AN         6C:3B:6B:80:EF:B5 -92  21    1.2%     10%  30.7kbps SaLIk_AP_strom   -> datovy radek
12 AN 5680MHz 00:0C:42:68:C3:CC -67  50    0.5%    100%  23.8kbps DAS-AP1-KA      -> datovy radek
}
program parse_snooper;
type
  TPosArray = array of Integer;
const
  cDataSeparator = '||';
// ---
  function SkipRow(aRow: string): Boolean;
  begin
    Result := (Trim(aRow) = '')
     or (Copy(Trim(aRow), 1, 1) = '/') //je to nejaky prikaz        
     or (Pos('Flags: ', aRow) > 0) //neco ned tabulkou                 
     or (Pos('-- [', aRow) > 0);
  end;
//
  function IsHeaderRow(aRow: string): Boolean;
  begin
    Result := (Pos('#', aRow) > 0)
      and (Pos('SIG SNR', aRow) > 0);
  end;
//
  procedure ClearColums(var aCol: TPosArray);
  var
    I: Integer;
  begin
    for I := 0 to Length(aCol) -1 do begin
      aCol[I] := -1;
    end;   
  end;  
//
  procedure GetColumnPositions(aRow: string; var aColumns: TPosArray);
  begin
    SetLength(aColumns, 10);
    ClearColums(aColumns);
        
    aColumns[0] := Pos('#', aRow) + 2;  //atributy
    //aColumns[1] := Pos('FREQ', aRow); //frekvence
    aColumns[1] := aColumns[0] + 3; //frekvence zacina hned za atributy (atributy maji max 2 znaky)
    aColumns[2] := Pos('ADDRES', aRow); //mac adresa
    aColumns[3] := Pos('SIG', aRow) - 1;  //signal
    aColumns[4] := Pos('SNR', aRow);  //snr
    aColumns[5] := Pos('OF-FREQ', aRow);  //vyuziti
    aColumns[6] := Pos('OF-TRAF', aRow);  //vyuzit
    //aColumns[7] := Pos('BW', aRow); //BW
    aColumns[7] := aColumns[6] + Length('OF-TRAF') + 1; //BW zacina za OFF-TRAF
    aColumns[8] := Pos('SSID', aRow); //ssid
    aColumns[9] := Length(aRow);  //KONEC       
  end;
//
  function HaveColumns(aCol: TPosArray): Boolean;
  begin
    Result := Length(aCol) > 0;
  end;  
// ---   
var
  I: Integer;
  row, rowOut, part: string;
  Columns: TPosArray;
  colIdx: Integer;
  StrLev, StrNoise, StrSNR: string;
begin
  ResultSL.Clear;
  SetLength(Columns, 0);  

  for I := 0 to InputSL.Count - 1 do begin
    row := InputSL.Strings[I];
    
    //radky, co me nezajimaji praskakuju
    if SkipRow(row) then begin
      CONTINUE;
    end;
    
    //zjistovani pozice bunek
    if (not HaveColumns(Columns)) then begin
      if IsHeaderRow(row) then begin
        GetColumnPositions(row, Columns);
      end;
      CONTINUE;      
    end;
    
    // -------------------------------------------------------------------------
        
    //parsovani dat -> [,],1/0,atributy,mac,ssid,radioname,freq,level,noise,snr,    
    rowOut := Format('[%s]%s', [ cDataSeparator, cDataSeparator ]);
    
    // #1 - online
    colIdx := 0;
    part := Copy(row, Columns[colIdx], Columns[colIdx + 1] - Columns[colIdx]);
    if (Pos('A', part) > 0) then begin
      rowOut := rowOut + '1' + cDataSeparator;
    end else begin
      rowOut := rowOut + '0' + cDataSeparator;
    end;

    //#2 - atributy
    rowOut := rowOut + Trim(Part) + cDataSeparator;

    //#3 - mac adresa
    colIdx := 2;
    part := Copy(row, Columns[colIdx], Columns[colIdx + 1] - Columns[colIdx]);
    rowOut := rowOut + Trim(part) + cDataSeparator;

    //#4 - ssid
    colIdx := 8;
    part := Copy(row, Columns[colIdx], Columns[colIdx + 1] - Columns[colIdx]);
    rowOut := rowOut + Trim(part) + cDataSeparator;

    //#5 - radioname
    //je prazdne, ve snooperu neni
    part := '';
    rowOut := rowOut + Trim(part) + cDataSeparator;

    //#6 - frekvence
    colIdx := 1;
    part := Copy(row, Columns[colIdx], Columns[colIdx + 1] - Columns[colIdx]);
    if (Trim(part) = '') then begin
      part := '-1';
    end;
    rowOut := rowOut + Trim(part) + cDataSeparator;

    //#7 - level
    colIdx := 3;
    part := Copy(row, Columns[colIdx], Columns[colIdx + 1] - Columns[colIdx]);
    if (Trim(part) = '') then begin
      part := '-1';
    end;    
    //kontroluju nevhodnou hodnotu intenzity signalu
    try
      if (StrToIntDef(part, -99) >= -19) then begin  //za cele 3 roky mereni byla nejvissi hodnota -20dBm, vetsi hodnota je "divna"
        part := part + '0';
      end;
    except
      part := '-150'; //není to číslo, něco je špatně .. zadám hodnotu -150
    end;        
    rowOut := rowOut + Trim(part) + cDataSeparator;

    //#8 - noise
    //je prazdne, ve snooperu neni
    part := '';
    if (Trim(part) = '') then begin
      part := '-1';
    end;    
    rowOut := rowOut + Trim(part) + cDataSeparator;

    //#9 - SNR
    colIdx := 4;
    part := Copy(row, Columns[colIdx], Columns[colIdx + 1] - Columns[colIdx]);
    if (Trim(part) = '') then begin
      part := '-1';
    end;    
    rowOut := rowOut + Trim(part) + cDataSeparator;

    ResultSL.Add(rowOut); //pridam radek
            
    // -------------------------------------------------------------------------             
  end; //end-for 
end.
