﻿{
  Výstupní řádek dat musí být ve formátu:
   
    [,],1/0,atributy,mac,ssid,radioname,freq,level,noise,snr,
         
    - 1/0 určuje jestli je zařízení online (1) nebo offline (0)
    - FREQ musí být čislo. Pokud není známá, použij hodnotu "-1"
    - LEVEL musí být čislo. Pokud není známá, použij hodnotu "-1"
    - NOISE musí být čislo. Pokud není známá, použij hodnotu "-1"   
    - SNT musí být čislo. Pokud není známá, použij hodnotu "-1"
    
    - [x] určuje oddělovač dat a musí být na začátku řádku
    - počet řádků ve výstupu není omezen
  
  Proměnné ve skriptu:    
    - InputSl => TStringList obsahující vstupní data
    - ResultSL => TStringList obsahující výstupní data
    
}
{
      ADDRESS           SSID                                                                                                                     BAND       FREQ SIG NF   SNR RADIO-NAME
ABPR  00:80:48:53:0C:6B ViaMedia volejte 602540540 DEJAS                                                                                         5ghz       5500 -89 -112 23  ViaMedia volejte
-- [Q quit|D dump|C-z

      ADDRESS           SSID                                                                                                                BAND   CHANNEL-WIDTH FREQ SIG   NF SNR RADIO-NAME
AB R  00:1E:DA:ED:AE:DA nwtkarlovice5g                                                                                                      5ghz-n 20mhz         5600 -67 -116  49
-- [Q quit|D dump|C-z

       ADDRESS           SSID                                                         CHANNEL                                                        SIG   NF SNR RADIO-NAME                                                        ROUTEROS-VERSION
  R  B 6C:3B:6B:80:EF:B5 SaLIk_AP_strom                                               5560/20-Ce/an                                                  -83 -112  29 6C3B6B80EFB5                                                      6.46.2
-- [Q quit|D dump|C-z 
}
program parse_scan;
type
  TPosArray = array of Integer;
const
  cDataSeparator = '||';
// ---
  function SkipRow(aRow: string): Boolean;
  begin
    Result := (Trim(aRow) = '')
     or (Copy(Trim(aRow), 1, 1) = '/') //je to nejaky prikaz
     or (Pos('Flags: A - active', aRow) > 0)
     or (Pos('[Q quit|', aRow) > 0);
  end;
//
  function IsHeaderRow(aRow: string): Boolean;
  begin
    Result := (Pos('ADDRESS', aRow) > 0);
  end;
//
  procedure ClearColumns(var aCol: TPosArray);
  var
    I: Integer;
  begin
    for I := 0 to Length(aCol) -1 do begin
      aCol[I] := -1;
    end;   
  end;  
//
  procedure GetColumnPositions(aRow: string; var aColumns: TPosArray);
  begin
    SetLength(aColumns, 10);
    ClearColumns(aColumns);
        
    aColumns[0] := 0; //atributy
    aColumns[1] := Pos('ADDRESS', aRow);  //mac
    aColumns[2] := Pos('SSID', aRow); //ssid
    
    aColumns[3] := Pos('BAND', aRow); //band
    if (aColumns[3] = 0) then begin
      aColumns[3] := Pos('CHANNEL', aRow);       
    end;
    
    aColumns[4] := Pos('FREQ', aRow); //freq
    if (aColumns[4] = 0) then begin
      //frekvenci nemam, budu ji zjistovat z CHANNEL-u
      aColumns[4] := Pos('CHANNEL', aRow);
    end;
        
    aColumns[5] := Pos('SIG', aRow) - 1; //level
    
    aColumns[6] := Pos('NF', aRow); //noise
    if (Pos('CHANNEL', aRow) > 0) then begin //pokud mam v hlavicce CHANEL, posteluju zacatek bunky pro NF
      aColumns[6] := aColumns[5] + Length('SIG') + 2;
    end;
    
    aColumns[7] := Pos('SNR', aRow); //snr
    aColumns[8] := Pos('RADIO-NAME', aRow); //radioname    

    if (Pos('ROUTEROS-VERSION', aRow) > 0) then begin //konec radku
      aColumns[9] := Pos('ROUTEROS-VERSION', aRow) - 1;
    end else begin
      aColumns[9] := Length(aRow);
    end;       
  end;
//
  function HaveColumns(aCol: TPosArray): Boolean;
  begin
    Result := Length(aCol) > 0;
  end;
// ---   
var
  I: Integer;
  row, rowOut, part: string;
  Columns: TPosArray;
  colIdx: Integer;
  StrLev, StrNoise, StrSNR: string;
begin
  ResultSL.Clear;
  SetLength(Columns, 0);  

  for I := 0 to InputSL.Count - 1 do begin
    row := InputSL.Strings[I];
    
    //radky, co me nezajimaji praskakuju
    if SkipRow(row) then begin
      CONTINUE;
    end;
    
    //zjistovani pozice bunek
    if (not HaveColumns(Columns)) then begin
      if IsHeaderRow(row) then begin
        GetColumnPositions(row, Columns);
      end;
      CONTINUE;      
    end;
    
    // -------------------------------------------------------------------------
    
    //parsovani dat -> [,],1/0,atributy,mac,ssid,radioname,freq,level,noise,snr,    
    rowOut := Format('[%s]%s', [ cDataSeparator, cDataSeparator ]);
    
    // #1 - online
    colIdx := 0;
    part := Copy(row, Columns[colIdx], Columns[colIdx + 1] - Columns[colIdx]);
    if (Pos('A', part) > 0) then begin
      rowOut := rowOut + '1' + cDataSeparator;
    end else begin
      rowOut := rowOut + '0' + cDataSeparator;
    end;
    
    //#2 - atributy
    //      A -> zarizeni je aktivni
    //      B -> zarizeni je AP
    //      N -> zarizeni pracuje v N streamu
    //      R -> zarizeni pracuje s RouterOS
    //      P -> indikator ze jsou vsechna data zasifrovana
    rowOut := rowOut + Trim(Part) + cDataSeparator;

    //#3 - mac adresa
    colIdx := 1;
    part := Copy(row, Columns[colIdx], Columns[colIdx + 1] - Columns[colIdx]);
    rowOut := rowOut + Trim(part) + cDataSeparator;

    //#4 - ssid
    colIdx := 2;
    part := Copy(row, Columns[colIdx], Columns[colIdx + 1] - Columns[colIdx]);
    rowOut := rowOut + Trim(part) + cDataSeparator;

    //#5 - radioname
    colIdx := 8;
    part := Copy(row, Columns[colIdx], Columns[colIdx + 1] - Columns[colIdx]);
    rowOut := rowOut + Trim(part) + cDataSeparator;

    //#6 - frekvence
    colIdx := 4;
    part := Copy(row, Columns[colIdx], Columns[colIdx + 1] - Columns[colIdx]);
    //pokud beru frekvenci z CHANNEL, je tam "5240/20-eeeC/ac"
    if (Pos('/', part) > 0) then begin
      part := Copy(part, 1, Pos('/', part) - 1); //vyberu jen frekvenci
    end;
    if (Trim(part) = '') then begin
      part := '-1';
    end;        
    rowOut := rowOut + Trim(part) + cDataSeparator;

    //#A1 - pripravim si urovne
    //level
    colIdx := 5;
    part := Copy(row, Columns[colIdx], Columns[colIdx + 1] - Columns[colIdx]);    
    StrLev := Trim(part);            

    //noise
    colIdx := 6;
    part := Copy(row, Columns[colIdx], Columns[colIdx + 1] - Columns[colIdx]);    
    StrNoise := Trim(part);    

    //SNR
    colIdx := 7;
    part := Copy(row, Columns[colIdx], Columns[colIdx + 1] - Columns[colIdx]);    
    StrSNR := Trim(part);    

    //#A2 - UPRAVA urovni:
    // - pokud je SNR mensi nez 0, hodnota signalu je mensi nez hladina sumu a protoze signal nemuze byt 3mistny
    // - musim si spravnou hodnotu vypocitat
    try
      //nouzove reseni, kdyby predchozi neuspelo
      if (StrToInt(StrLev) >= -19) then begin  //za cele 3 roky mereni byla nejvissi hodnota -20dBm, vetsi hodnota je "divna"
        StrLev := StrLev + '0'; //pridam "0" a vzniken hodnota 1xx, ktera se pri nasledujicim mereni prepise vetsi hodnotou
      end;
    except
      //hodnota neni cislo
    end;
    
    //#A3 - doplnim urovne
    //#7 - level
    if (Trim(StrLev) = '') then begin
      StrLev := '-1';
    end;     
    rowOut := rowOut + Trim(StrLev) + cDataSeparator;

    //#8 - noise
    if (Trim(StrNoise) = '') then begin
      StrNoise := '-1';
    end;      
    rowOut := rowOut + Trim(StrNoise) + cDataSeparator;

    //#9 - SNR
    if (Trim(StrSNR) = '') then begin
      StrSNR := '-1';
    end;    
    rowOut := rowOut + Trim(StrSNR) + cDataSeparator;
    
    ResultSL.Add(rowOut); //pridam radek
            
    // -------------------------------------------------------------------------             
  end; //end-for  
end.
