﻿/*
 * ohradnik.c
 *
 * Created: 7.6.2012 1:31:45
 *  Author: SaLIk
 */ 


#define F_CPU	8E6			//interni oscilator 8MHz
//-
#define LED1	PB0			//nastaveni indikacnich ledek
#define LED2	PB1
#define LED3	PB2
#define LED4	PB3
#define LED5	PB4
#define HWSW	PB7
#define INFOLED	PD1
//--
#define TBAT	PB6			//nastaveni spinani tranzistoru
#define TPULSE	PB5
//--
#define BTN		PD0			//tlacitko (zmacnute = LOG1)
//--
#define BAT		PC1			//napeti baterie
#define PWR		PC0			//delka pulzu



#include <avr/io.h>
#include <util/delay.h>
#include <avr/interrupt.h>



//globalni promenne
volatile unsigned int bat_val;
volatile unsigned int pot_val = 65535;
volatile unsigned int led_counter = 11;
volatile unsigned char led_power_counter = 0;



void io_init(void) {
	//port B na vystupy s log 0
	DDRB = 0xFF;
	PORTB = 0x00;
	
	//port D na vstupy s vysokou impedanci
	DDRD = 0x00;
	PORTD = 0x00;
	
	//port C na vstupy s vysokou impedanci
	DDRC = 0x00;
	PORTC = 0x00;
}

void adc_init (void) {
	ADMUX = 0x00;	//reference podle napeti na pinu AREF, zarovnani doprava, nulty pin pro prevod
	ADCSRA = 0x06;	//delicka 64, pro f=8 MHz je kmitocet 125kHz (pro zachovani presnosti musi byt do 200kHz, takze ok)
}

unsigned int adc_get_value(unsigned char adc_ch) {
unsigned int hodnota;
	
ADMUX = ADMUX & 0xF0;		//vyresetuju kanal prevodniku
ADMUX = ADMUX | adc_ch;		//nastavim novy kanal
	
ADCSRA = ADCSRA | 0xC0;				//zapnu prevodnik a spustim jeden prevod (trva 25 cyklu)
while ( !(ADCSRA & (1<<ADIF)) ) {;}	//cekam na dokonceni prevodu

hodnota = ADCW;						//prectu udaj

ADCSRA = ADCSRA | 0x10;				//resetuju interupt flag
ADCSRA = ADCSRA & ~(0x80);			//vypinam prevodnik

return hodnota;
}

void timer_init(void) {
	TCCR1A = 0x00;					//bez odstraneni sumu, aktivni sebezna hrana, normalni rezim = citac
	TCCR1B = 0x00;
	TIMSK = (TIMSK & 0xC3) | 0x04;	//povolim jen preruseni pri preteceni
}

void timer_start(void) {
	//pozadovany cas je 1.2s
	//pro f=8MHz a delicku 256 musi byt pocatecni hodnota 28035
	
	TCNT1 = 0x6D83;			//pocatecni hodnota 28035
	TCCR1B = TCCR1B | 0x04;	//nastavi delicku 256 a tim spusti citac
}

void timer_stop(void) {
	TCCR1B = TCCR1B & 0xF8;	//zrusim nastaveni delicky a tim zastavim citac
}

unsigned char get_portd_pin_state(unsigned char pin_name) {	
	return PIND & (1<<pin_name);
}

void set_portb_pin(unsigned char pin_name, unsigned char pin_state) {
	if (pin_state == 0) {
		PORTB = PORTB & (~(1<<pin_name));
	} else {
		PORTB = PORTB | (1<<pin_name);
	}	
}

void set_portc_pin(unsigned char pin_name, unsigned char pin_state) {
	if (pin_state == 0) {
		PORTC = PORTC & (~(1<<pin_name));
	} else {
		PORTC = PORTC | (1<<pin_name);
	}
}

void set_portd_pin(unsigned char pin_name, unsigned char pin_state) {
	if (pin_state == 0) {
		PORTD = PORTD & (~(1<<pin_name));
	} else {
		PORTD = PORTD | (1<<pin_name);
	}
}

void shock_the_pig(unsigned int pwr_v) {
	unsigned char count, max_count;
	/*
		max 512 (2.5V)	-> impulz delky 93.24 ms	->	14 cyklu
		min 0	(0.0V)	-> impulz delky 13.32 ms	->	2 cykly
		
		frekvence spinani 300 Hz
	*/
	
	max_count = (pwr_v / 42) + 2;
	
	count = 0;	
	while (count < max_count) {
		set_portb_pin(HWSW,1);
		_delay_ms(3.33);
		set_portb_pin(HWSW,0);
		_delay_ms(3.33);
		//--
		count = count + 1;
	}	
}

ISR(TIMER1_OVF_vect) {
	unsigned char bckp;
	
	timer_stop();
	//--
	bckp = SREG;	
		
	//kontroluju, jestli uz nemam vybitou baterku, pri 10.4V na baterce bude na delici 3.06V -> 626, necham ho pracovat trochu dele -> 600
	if (bat_val >= 600) {
		shock_the_pig(pot_val);		//vyslu do ohradniku elektriku
		led_power_counter = 0;		//rozsviti pak v hlavni smycce na chvilku ledku
	}	
	
	SREG = bckp;
	//--
	timer_start();
}



int main(void)
{
	unsigned char adc_count = 0;
	unsigned int tmp, pot_v;
		
	cli();		
	io_init();
	timer_init();
	adc_init();	
		
	timer_start();
	
    while(1)
    {							
		//--------------------------------------------------------------------------------		
		// hlidam napeti baterky
		bat_val = adc_get_value(BAT);
		
		//kontroluju zmenu nastaveni
		pot_v = adc_get_value(PWR);
		if (pot_v > 512) {	//kvuli opacne danemu potenciometru
			tmp = 0;
		} else {
			tmp = 512 - pot_v;
		}
		
		//pri prvnim spusteni beru rovnou hodnotu potaku
		if (pot_val == 65535) {
			pot_val = tmp;
			led_counter = 501; //aby se nerozsvitily ledky (dobre, kdyz pri preskoku jiskry poklesne napeti, tak po restartu cpu nasleduje dalsi jiskra zase hned za 1s)
		}
		
		//jestli nekdo otocil potakem, rozsvitim ledky pro zobrazeni nastaveni
		if (tmp > pot_val) {
			if ( (tmp-pot_val) > 30) {
				//pokud je rozdil o 0.1V beru to jako, ze doslo ke zmene a rozsvitim ledky
				adc_count = adc_count + 1;
			} else {
				adc_count = 0;
			}
		} else {
			if ( (pot_val-tmp) > 30) {
			//pokud je rozdil o 0.1V beru to jako, ze doslo ke zmene a rozsvitim ledky
			adc_count = adc_count + 1;
			} else {
				adc_count = 0;
			}
		}
	
		if (adc_count > 5) {			//pokud je X prevodu za sebou odlisnych od predchozi hodnoty			
			
			if (pot_v > 512) {			//kvuli tomu, aby potak doprava pridaval
				pot_val = 0;
			} else {
				pot_val = 512 - pot_v;	//hodnotu si schovam (kvuli spravnemu "volume")
			}
			
			led_counter = 0;		//rozsvitim ledky
			adc_count = 0;			//reset pocitadla ruznych hodnot prevodu
		}		
		//--------------------------------------------------------------------------------
		
		//--------------------------------------------------------------------------------	
		//rozsviceni ledky o informaci, ze vydal impulz
		if (led_power_counter < 10) {  //bude svitit 100 ms
			set_portd_pin(INFOLED,1);
			led_power_counter = led_power_counter + 1;
		} else {
			set_portd_pin(INFOLED,0);
		}
		//--------------------------------------------------------------------------------
		
		//--------------------------------------------------------------------------------
		// po stisku tlacitka zobrazim stav baterie a nastaveni pulzu	
        if (get_portd_pin_state(BTN)) {
	        led_counter = 0;	//vynuluju pocitadlo a tim rozsvitim informacni ledky
        }
		//--------------------------------------------------------------------------------
		
		//--------------------------------------------------------------------------------	
		//pokud menim hodnotu nebo jsem stiskl tlacitko (led_counter je 0) pomoci ledek zobrazim stav baterky a nastaveni pulzu
		if (led_counter < 500) {	//bude svitit 5 sekund
			
			if (led_counter == 0) { cli(); }	//pokud mam zobrazovat nastaveni, zakazu obsluhu preruseni (citac necham bezet)
			
			if (led_counter % 2) {
				//pri lichem cisle nastavuju stav baterky
				set_portb_pin(TBAT,1);
				set_portb_pin(TPULSE,0);
								
				//	12.0V -> 3.6V -> 737
				//	10.4V -> 3.06V -> 626, necham baterku vybit trochu vic -> 600
				
				/*
					737 - 710
					709 - 682
					681 - 654
					653 - 626
					625 - 600
				*/
				
				if (pot_val > 737) { pot_val = 737; } //hodnota muze byt vyssi, pokud baterka ma vic jak 12V
				
				if ((pot_val <= 737) && (pot_val >= 710)) {
					tmp = 5;
				} else {
					if ((pot_val <= 709) && (pot_val >= 682)) {
						tmp = 4;
					} else {
						if ((pot_val <= 681) && (pot_val >= 654)) {
							tmp = 3;
						} else {
							if ((pot_val <= 653) && (pot_val >= 626)) {
								tmp = 2;
							} else {
								tmp = 1;
							}
						}
					}
				}
				
				set_portb_pin(LED1,1);
				if (tmp > 1) {
					set_portb_pin(LED2,1);
				} else { 
					set_portb_pin(LED2,0);
				}
				if (tmp > 2) {
					set_portb_pin(LED3,1);
				} else {
					set_portb_pin(LED3,0);
				}				
				if (tmp > 3) {
					set_portb_pin(LED4,1);
				} else {
					set_portb_pin(LED4,0);
				}
				if (tmp > 4) {
					set_portb_pin(LED5,1);
				} else {
					set_portb_pin(LED5,0);
				}				
			} else {
				//pri sudem cisle nastavuju stav pulzu
				set_portb_pin(TBAT,0);
				set_portb_pin(TPULSE,1);
				
				//	0.0V -> 0
				//	2.5V -> 512
				
				/*
					512 - 410
					409 - 307
					306 - 204
					203 - 101
					100 - 000
				*/
				
				if ((pot_val <= 512) && (pot_val >= 410)) {
					tmp = 5;
				} else {
					if ((pot_val <= 409) && (pot_val >= 304)) {
						tmp = 4;
					} else {
						if ((pot_val <= 306) && (pot_val >= 204)) {
							tmp = 3;
						} else {
							if ((pot_val <= 203) && (pot_val >= 101)) {
								tmp = 2;
							} else {
								tmp = 1;
							}
						}
					}
				}								
							
				set_portb_pin(LED1,1);
				if (tmp > 1) {
					set_portb_pin(LED2,1);
				} else { 
					set_portb_pin(LED2,0);
				}
				if (tmp > 2) {
					set_portb_pin(LED3,1);
				} else {
					set_portb_pin(LED3,0);
				}				
				if (tmp > 3) {
					set_portb_pin(LED4,1);
				} else {
					set_portb_pin(LED4,0);
				}
				if (tmp > 4) {
					set_portb_pin(LED5,1);
				} else {
					set_portb_pin(LED5,0);
				}
			}
			
			led_counter = led_counter + 1;
		} else {			
			set_portb_pin(TBAT,0);
			set_portb_pin(TPULSE,0);

			set_portb_pin(LED1,0);
			set_portb_pin(LED2,0);
			set_portb_pin(LED3,0);
			set_portb_pin(LED4,0);
			set_portb_pin(LED5,0);			
			
			//kdyz je baterka slaba, sviti prvni indikacni ledka (baterka 10.4V, na odporu 3.06V pri Vcc = 5.3V)
			if (bat_val < 600) {
				set_portb_pin(LED1,1);
				set_portb_pin(LED2,0);
				set_portb_pin(LED3,0);
				set_portb_pin(LED4,0);
				set_portb_pin(LED5,0);																
				set_portb_pin(TBAT,1);
			}
			
			//ledky uz nesviti, povolim obsluhu preruseni			
			if ((SREG & 0x80) == 0) { sei(); }
		}
		//--------------------------------------------------------------------------------
				
		_delay_ms(10);		
    }		
	return 0;
}