/*
	Funkce pro ovladani audio pameti ISD1760PY

	Pozn.: pri komunikaci pres SPI se soucasne s odeslanim 1B i 1B prijma
*/


/*
	Hlavickove soubory
*/

#include "global.h"
#include "isd1760py.h"


/*
	Tela funkci
*/

void isd_init(void) {	
	DDRB = DDRB | (1<<ISD_SCK_B) | (1<<ISD_MOSI_B) | (1<<ISD_SS_B);		//MOSI,SCK,SS nastavi na vystup
	DDRB = DDRB & ~(1<<ISD_MISO_B);										//MISO na vstup
	SPCR = (1<<SPE) | (1<<MSTR) | (1<<DORD) | (0<<SPR0) | (1<<SPR1);	//zapne SPI rozhrani, nastavi MASTER a hodinovy signal na F_CPU/16,
																		//prvni se vysila nejnizsi bit a aktivni hranu hodin na sestupnou
	isd_neg_ss(1);														//nastavim SlaveSelect na log 1 (data se odesilaji pri SS = log0)
}

void isd_neg_ss(unsigned char state) {
	switch(state) {
		case 0: PORTB = PORTB & ~(1<<ISD_SS_B);
				break;
		case 1: PORTB = PORTB | (1<<ISD_SS_B);
	}
}

void isd_master_transmit(unsigned char data) {
	SPDR = data;														//odesilam pozadovana data po SPI sbernici
	while ( !(SPSR & (1<<SPIF)) );										//cekam na dokonceni prenosu
}

unsigned char isd_master_read(unsigned char wait_for_complete) {	
	unsigned char data;
	if (wait_for_complete == 1) {										//cekat na dokonceni predchozi operace
		while ( !(SPSR & (1<<SPIF)) );									//cekam na dokonceni prenosu
	}
	data = SPDR;
	return data;														//prectu ziskana data
}

void isd_power_up(void) {
	isd_neg_ss(0);
	_delay_ms(10);														//posilam data do ISD1760PY
	isd_master_transmit(0x01);											//prikaz PU (power up)
	isd_master_transmit(0x00);
	isd_neg_ss(1);
	_delay_ms(10);
}

void isd_power_down(void) {
	isd_neg_ss(0);
	_delay_ms(10);
	isd_master_transmit(0x07);											//prikaz PD (power down)
	isd_master_transmit(0x00);
	isd_neg_ss(1);
	_delay_ms(10);
}

void isd_stop(void) {
	isd_neg_ss(0);
	_delay_ms(10);
	isd_master_transmit(0x02);											//prikaz STOP
	isd_master_transmit(0x00);
	isd_neg_ss(1);
	_delay_ms(10);
}

void isd_record(unsigned char led_on) {
	isd_set_record_path();												//nastavy cestu pro vstup zvuku
	isd_clear_int();

	isd_neg_ss(0);
	_delay_ms(10);

	if (led_on == 1) {
		isd_master_transmit(0x91);										//prikaz SET_REC (record, led ON->4bit prikazu = 1, 0x91)
	} else {
			 isd_master_transmit(0x81);									//prikaz SET_REC (record, led OFF->4bit prikazu = 0, 0x81)				
		   }
	isd_master_transmit(0x00);
	isd_master_transmit(0x10);											//2B -> startovni adresa nahravani (0x010)
	isd_master_transmit(0x00);
	isd_master_transmit(0xEF);											//3B -> konecna adresa nahravani (0x1EF)
	isd_master_transmit(0x01);
	isd_master_transmit(0x00);
	isd_neg_ss(1);
	_delay_ms(10);
}

void isd_play(unsigned char led_on) {
	isd_set_playback_path();											//nastavy cestu pro vystup zvuku
	isd_clear_int();

	isd_neg_ss(0);
	_delay_ms(10);

	if (led_on == 1) {
		isd_master_transmit(0x90);										//prikaz SET_PLAY (record, led ON->4bit prikazu = 1, 0x90)
	} else {
			 isd_master_transmit(0x80);									//prikaz SET_PLAY (record, led OFF->4bit prikazu = 0, 0x80)				
		   }
	isd_master_transmit(0x00);
	isd_master_transmit(0x10);											//2B -> startovni adresa prehravani (0x010)
	isd_master_transmit(0x00);
	isd_master_transmit(0xEF);											//3B -> konecna adresa prehravani (0x1EF)
	isd_master_transmit(0x01);
	isd_master_transmit(0x00);
	isd_neg_ss(1);
	_delay_ms(10);
}

void isd_erase(void) {
	isd_neg_ss(0);
	_delay_ms(10);
	isd_master_transmit(0x43);											//prikaz G_ERASE (global erase)
	isd_master_transmit(0x00);
	isd_neg_ss(1);
	_delay_ms(10);
}

void isd_set_record_path(void) {										//nastavi jako vstup pro nahravani analagovy vstup
	isd_neg_ss(0);
	_delay_ms(10);
	isd_master_transmit(0x65);											//prikaz WR_APC2 (zapis dat do APC registru)
	isd_master_transmit(0x00);											//vstup z AnaIn
	isd_master_transmit(0x0D);											//vystup Speaker +/- vypnuty, vAlert vypnute
	isd_neg_ss(1);
	_delay_ms(10);	
}

void isd_set_playback_path(void) {										//nastavi jako vystup pro prehravani analogovy vystup, a prehravat jen z pameti
	isd_neg_ss(0);
	_delay_ms(10);
	isd_master_transmit(0x65);											//prikaz WR_APC2 (zapis dat do APC registru)
	isd_master_transmit(0xC0);											//vystup z AnaOut (AUX), zdroj zvuku jen pamet
	isd_master_transmit(0x0D);											//vystup Speaker +/- vypnuty, vAlert vypnute
	isd_neg_ss(1);
	_delay_ms(10);	
}

void isd_clear_int(void) {												//vymazu indikaci preruseni a EOM bit
	isd_neg_ss(0);
	_delay_ms(10);
	isd_master_transmit(0x04);											//prikaz CLR_INT 
	isd_master_transmit(0x00);
	isd_neg_ss(1);
	_delay_ms(10);
}

unsigned char read_status(void) {										//precte status registr
	unsigned char status;
	isd_neg_ss(0);
	_delay_ms(10);

	isd_master_transmit(0x05);											//prikaz RD_STATUS
	isd_master_transmit(0x00);
	isd_master_transmit(0x00);

	status = isd_master_read(0);										//prectu status registr	

	isd_neg_ss(1);
	_delay_ms(10);

	return status;
}

unsigned char isd_in_record(void) {
	unsigned char stat;
	stat = read_status();
	
	if ((stat & 0x08) != 0x00) {										//00001000 - indikace probihamiciho nahravani
	  return 1;
	} else {
			 return 0;
		   }
}

unsigned char isd_in_play(void) {
	unsigned char stat;
	stat = read_status();
	
	if ((stat & 0x04) != 0x00) {										//00000100 - indikace probihamiciho prehravani
	  return 1;
	} else {
			 return 0;
		   }	
}

unsigned char isd_is_ready(void) {
	/* 
		Pri RDY=1 je obvod pripraven prijimat dalsi prikazy.
	 	Vyjimkou jsou "RESET, CLR_INT, RD_STATUS, PD", ty se vykonaji i pri RDY=0 a
		"STOP", ktere se akceptuje pokud prave zarizeni nahrava nebo prehrava "REC,PLAY"
	 */
	unsigned char stat;
	stat = read_status();

	if ((stat & 0x01) != 0x00) {										//00000001 - indikace pripravenosti pro prijem dalsiho prikazu
	  return 1;
	} else {
			 return 0;
		   }	
}
