/*
	Globalni promenne a funkce
*/

#ifndef _GLOBAL_H
#define _GLOBAL_H


/*
	Definice
*/ 

//rychlost procesoru
#define F_CPU 1000000UL

//piny pro led diody
#define LED_RED_D	0
#define	LED_GREEN_D	1

//piny pro tlacitka
#define	BUTTON1_D	3
#define BUTTON2_D	4

//adresa pro ulozeni casu v eeprom
#define EE_INIT		0
#define EE_INIT_VAL	9
#define EE_HOUR		1


/*
	Hlavickove soubory
*/

#include <avr/io.h>					//nazvy pinu
#include <avr\interrupt.h>			//prace s vektory preruseni
#include <util/delay.h>				//makra na zpozdeni
#include <avr/sleep.h>				//pro uspani procesoru
#include <avr/eeprom.h>				//pro praci s eepromkou v atmelu
//
#include "fm_transmitter.h"			//ovladni FM vysilace
#include "isd1760py.h"				//ovladni audio pameti
#include "ds1302.h"					//ovladni obvodu realneho casu


/*
	Glbalni promenne
*/  

unsigned char year,month,day,hour,minute,setting_index;	//pro uchovani nasteveneho a precteneho datumu, casu a idnexu upravovaneho/cteneho udaje
unsigned char btn1_down_cnt,btn2_down_cnt;				//pro zjisteni jak dlouho je tlacitko stisknuto
unsigned char cache_run_cnt,timer_run_cnt;				//pocitadlo poctu prehravani zpravy a poctu docitani casovace
unsigned char run_hour;									//hodna, kdy se keska bude poustet


/*
	Funkce
*/

void set_led_state(unsigned char port_pin, unsigned char state);
void flash_value(unsigned char led, unsigned char value);

void main_init(void);
void buttons_init(void);
unsigned char get_button_state(unsigned char port_pin);

void write_TCNT2(unsigned char start);
void write_OCR2(unsigned char start);
void sleep_timer_init(void);
void sleep_timer_start(void);
void sleep_timer_stop(void);
void sleep_mcu(void);

void eeprom_write(unsigned int address, unsigned char data);
unsigned char eeprom_read(unsigned int address);





#endif
