/*
	Funkce pro ovladani FM vysilace
*/


/*
	Hlavickove soubory
*/

#include "global.h"
#include "fm_transmitter.h"


/*
	Tela funkci
*/

void fm_switch_init(void) {
	DDRB = DDRB | (1<<FM_SWITCH_B);			//pin je vyspup
	PORTB = PORTB & !(1<<FM_SWITCH_B);		//stav je log 0

	fm_transmitter(0);						//fm vysilac vypnuty
}

void fm_transmitter(char state) {
	//zapne nebo vypne (1/0) FM vysilac
	switch(state) {
		case 0:	PORTB = PORTB & ~(1<<FM_SWITCH_B);
				break;
		case 1:	PORTB = PORTB | (1<<FM_SWITCH_B);
	}
}
