/*
	Funkce pro ovladani obvodu realneho casu DS1302
*/


/*
	Hlavickove soubory
*/

#include "global.h"
#include "ds1302.h"


/*
	Tela funkci
*/

void ds1302_init(void) {	
	ds1302_set_clock_direction(1);										//hodiny jsou vystupni pin
	ds1302_set_ce_direction(1);											//ce je vystupni pin
	ds1302_set_io_direction(1);											//io je vystupni pin
	ds1302_set_clock_val(0);											//hodiny jsou vystupni pin
	ds1302_set_ce_val(0);												//ce je vystupni pin
	ds1302_set_io_val(0);												//io je vystupni pin	
}

void ds1302_set_clock_direction(unsigned char state) {					//nastaveni smeru pinu CLK
	switch(state) {
		case 0: DDRD = DDRD & ~(1<<DS_SCLK_D);
				break;
		case 1: DDRD = DDRD | (1<<DS_SCLK_D);
	}
}

void ds1302_set_ce_direction(unsigned char state) {						//nastaveni smeru pinu CE
	switch(state) {
		case 0: DDRD = DDRD & ~(state<<DS_CE_D);
				break;
		case 1: DDRD = DDRD | (state<<DS_CE_D);
	}
}

void ds1302_set_io_direction(unsigned char state) {						//nastaveni smeru pinu IO
	switch(state) {
		case 0: DDRD = DDRD & ~(1<<DS_IO_D);
				break;
		case 1: DDRD = DDRD | (1<<DS_IO_D);
	}
}

void ds1302_set_clock_val(unsigned char state) {						//nastavi hodnotu CLK vystupu
	switch(state) {
		case 0: PORTD = PORTD & ~(1<<DS_SCLK_D);
				break;
		case 1: PORTD = PORTD | (1<<DS_SCLK_D);
	}
}

void ds1302_set_ce_val(unsigned char state) {							//nastavi hodnotu CE vystupu
	switch(state) {
		case 0: PORTD = PORTD & ~(1<<DS_CE_D);
				break;
		case 1: PORTD = PORTD | (1<<DS_CE_D);
	}
}

void ds1302_set_io_val(unsigned char state) {							//nastaveni hdonoty IO vystupu
	switch(state) {
		case 0: PORTD = PORTD & ~(1<<DS_IO_D);
				break;
		case 1: PORTD = PORTD | (1<<DS_IO_D);
	}
}

unsigned char ds1302_get_io_val(void) {									//zjisti hodnotu IO pinu
	if (PIND & (1<<DS_IO_D)) {
		return 1;
	} else {
				return 0;
		   }
}

void ds1302_clock_tick(void) {											//zmeni hodiny a tim potvrdi data na IO pinu
  	_delay_us(5);
  	ds1302_set_clock_val(1);
  	_delay_us(5);
  	ds1302_set_clock_val(0);
  	_delay_us(5);
}

unsigned char ds1302_read_byte(unsigned char address) {					//nacte byte na zadane adrese
	unsigned char cnt,data;

	ds1302_init();														//vsechno na vystup a log0
	ds1302_set_ce_val(1);												//rikam DS at ceka data
	
	for (cnt=0; cnt<8; cnt++) {											//odesilam prikaz na cteni z adresy
		if ((address & 0x01) == 1) {
		  ds1302_set_io_val(1);
		} else { 
				 ds1302_set_io_val(0);
			   }

		address = address >> 1;											//dalsi bit adresy
		ds1302_clock_tick();											//update hodin
	}	//for

	ds1302_set_io_direction(0);											//io pin na vstup
	data = 0;
	
	for (cnt=0; cnt<8; cnt++) {	
		_delay_us(2);
		data = data >> 1;
		data = data | (ds1302_get_io_val()<<7);
		ds1302_clock_tick();											//update hodin
	}
	ds1302_set_io_val(0);
	ds1302_set_ce_val(0);

	return data;														//zjistenou hodnotu predam
}

void ds1302_write_byte(unsigned char address, unsigned char data) {		//zapise data na danou adresu
	unsigned char cnt;

	ds1302_init();
	ds1302_set_ce_val(1);
	
	for (cnt=0; cnt<8; cnt++) {											//odesilam adresu
		if ((address & 0x01) == 1) {
		  ds1302_set_io_val(1);
		} else { 
				 ds1302_set_io_val(0);
			   }

		address = address >> 1;											//dalsi bit adresy
		ds1302_clock_tick();											//update hodin
	}

	for (cnt=0; cnt<8; cnt++) {											//odesilam data
		if ((data & 0x01) == 1) {
		  ds1302_set_io_val(1);
		} else { 
				 ds1302_set_io_val(0);
			   }

		data = data >> 1;												//dalsi bit dat
		ds1302_clock_tick();											//update hodin
	}

	ds1302_set_io_val(0);
	ds1302_set_ce_val(0);		
}

void ds1302_set_date(unsigned char year, unsigned char month, unsigned char day) {		//ulozi do ds1302 datum
	ds1302_write_byte(0x8E, 0x00);				//povolim zapis (WP bit = 0)
	ds1302_write_byte(0x80, 0x80);				//zastaveni hodin
	ds1302_write_byte(0x8C, bin2bcd(year));		//zapisuju rok
	ds1302_write_byte(0x88, bin2bcd(month));	//zapisuju mesic
	ds1302_write_byte(0x86, bin2bcd(day));		//zapisuju den
	ds1302_write_byte(0x80, 0x00);				//zapisuju sekundy (0 sekund) a spusteni hodin
	ds1302_write_byte(0x8E, 0x80);				//zakazu zapis (WP bit = 1)
}

void ds1302_set_time(unsigned char hour, unsigned char minute) {						//zapise hodiny a minuty
	ds1302_write_byte(0x8E, 0x00);					//povolim zapis (WP bit = 0)
	ds1302_write_byte(0x80, 0x80);					//zastaveni hodin
	ds1302_write_byte(0x84, bin2bcd(hour) & 0x3F);	//zapisuju hodiny (24 hod. mode)
	ds1302_write_byte(0x82, bin2bcd(minute));		//zapisuju minuty
	ds1302_write_byte(0x80, 0x00);					//zapisuju sekundy (0 sekund) a spusteni hodin
	ds1302_write_byte(0x8E, 0x80);					//zakazu zapis (WP bit = 1)	
}

unsigned char ds1302_read_year(void) {				//prectu aktualni rok
	return bcd2bin(ds1302_read_byte(0x8D));
}

unsigned char ds1302_read_month(void) {				//prectu aktualni mesic
	return bcd2bin(ds1302_read_byte(0x89));
}

unsigned char ds1302_read_day(void) {				//prectu aktualni den
	return bcd2bin(ds1302_read_byte(0x87));
}

unsigned char ds1302_read_hour(void) {				//prectu aktualni hodinu
	return bcd2bin(ds1302_read_byte(0x85));
}

unsigned char ds1302_read_minute(void) {			//prectu aktualni minuty
	return bcd2bin(ds1302_read_byte(0x83));
}

unsigned char bcd2bin(unsigned char bcd_val) {							//prevod z BCD kodu na binarni
	return ((bcd_val >> 4) * 10) + (bcd_val & 0x0F);
}

unsigned char bin2bcd(unsigned char bin_val) {							//prevod z binarniho kodu do BCD
	return ((bin_val/10) << 4) + (bin_val % 10);
}
